"""initial clean schema

Revision ID: bb4f6ecc5981
Revises: 
Create Date: 2026-01-01 16:27:29.693379

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'bb4f6ecc5981'
down_revision: Union[str, Sequence[str], None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('cron_status',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('is_active', sa.Boolean(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('discount_codes',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('code', sa.String(length=50), nullable=False),
    sa.Column('percent', sa.Integer(), nullable=False),
    sa.Column('expires_at', sa.DateTime(), nullable=True),
    sa.Column('usage_limit', sa.Integer(), nullable=True),
    sa.Column('used_count', sa.Integer(), nullable=False),
    sa.Column('per_user_limit', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('code')
    )
    op.create_table('notification_logs',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('user_id', sa.BigInteger(), nullable=False),
    sa.Column('order_id', sa.Integer(), nullable=False),
    sa.Column('notification_type', sa.String(length=50), nullable=False),
    sa.Column('sent_at', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('plan_categories',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('type', sa.String(length=20), nullable=False),
    sa.Column('title', sa.String(length=50), nullable=False),
    sa.Column('description', sa.String(length=255), nullable=True),
    sa.Column('is_full', sa.Boolean(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('settings',
    sa.Column('key', sa.String(length=100), nullable=False),
    sa.Column('value', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('key')
    )
    op.create_table('unlimited_rotation_groups',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('start_day', sa.Integer(), nullable=False),
    sa.Column('end_day', sa.Integer(), nullable=False),
    sa.Column('discount_percent', sa.Float(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('user_phones',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('phone_number', sa.String(), nullable=False),
    sa.Column('username', sa.String(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('user_id')
    )
    op.create_table('users',
    sa.Column('user_id', sa.BigInteger(), nullable=False),
    sa.Column('username', sa.String(length=32), nullable=True),
    sa.Column('status', sa.String(length=20), nullable=False),
    sa.Column('invite_code', sa.String(length=20), nullable=True),
    sa.Column('referred_by', sa.BigInteger(), nullable=True),
    sa.Column('gift_credit', sa.Integer(), server_default=sa.text('0'), nullable=False),
    sa.PrimaryKeyConstraint('user_id')
    )
    op.create_table('plans',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.Column('type', sa.String(length=20), nullable=False),
    sa.Column('category_id', sa.Integer(), nullable=False),
    sa.Column('price', sa.Float(), nullable=False),
    sa.Column('description', sa.String(length=255), nullable=True),
    sa.Column('status', sa.String(length=20), nullable=False),
    sa.Column('user_limit', sa.Integer(), nullable=False),
    sa.Column('volume_limit', sa.Float(), nullable=True),
    sa.Column('is_full', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['category_id'], ['plan_categories.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('link_pool',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('url', sa.String(length=255), nullable=False),
    sa.Column('capacity', sa.Integer(), nullable=False),
    sa.Column('used_users', sa.Integer(), nullable=False),
    sa.Column('status', sa.String(length=20), nullable=False),
    sa.Column('type', sa.Enum('volume', 'unlimited', name='linktype'), nullable=False),
    sa.Column('plan_id', sa.Integer(), nullable=True),
    sa.Column('admin_label', sa.String(length=100), nullable=True),
    sa.Column('admin_note', sa.String(length=255), nullable=True),
    sa.ForeignKeyConstraint(['plan_id'], ['plans.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(
        'ix_link_pool_plan_id',
        'link_pool',
        ['plan_id']
    )
    op.create_table('orders',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('order_code', sa.String(length=20), nullable=False),
    sa.Column('user_id', sa.BigInteger(), nullable=False),
    sa.Column('plan_id', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('start_date', sa.DateTime(), nullable=False),
    sa.Column('expiration_date', sa.DateTime(), nullable=False),
    sa.Column('assigned_link_url', sa.String(), nullable=True),
    sa.Column('assigned_link_id', sa.Integer(), nullable=True),
    sa.Column('last_notified_at', sa.DateTime(), nullable=True),
    sa.Column('renewed_to', sa.Integer(), nullable=True),
    sa.Column('payment_method', sa.String(length=20), nullable=False),
    sa.Column('payment_status', sa.Enum('pending', 'approved', 'rejected', 'expired', name='paymentstatus'), nullable=False),
    sa.Column('receipt_file_id', sa.String(length=200), nullable=True),
    sa.Column('receipt_type', sa.String(length=10), nullable=True),
    sa.Column('receipt_value', sa.String(), nullable=True),
    sa.Column('admin_note', sa.String(length=255), nullable=True),
    sa.Column('config_sent', sa.Boolean(), nullable=False),
    sa.Column('renew_order_id', sa.Integer(), nullable=True),
    sa.Column('final_price', sa.Integer(), nullable=True),
    sa.Column('discount_percent', sa.Integer(), nullable=True),
    sa.Column('discount_code', sa.String(length=50), nullable=True),
    sa.ForeignKeyConstraint(['assigned_link_id'], ['link_pool.id'], ),
    sa.ForeignKeyConstraint(['plan_id'], ['plans.id'], ),
    sa.ForeignKeyConstraint(['renew_order_id'], ['orders.id'], ),
    sa.ForeignKeyConstraint(['renewed_to'], ['orders.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.user_id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('order_code')
    )
    op.create_index(
        'ix_orders_user_id',
        'orders',
        ['user_id']
    )

    op.create_index(
        'ix_orders_order_code',
        'orders',
        ['order_code'],
        unique=True
    )
    op.create_index(
        'ix_orders_user_id_expiration_date',
        'orders',
        ['user_id', 'expiration_date']
    )

    op.create_table('discount_usages',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('user_id', sa.BigInteger(), nullable=False),
    sa.Column('discount_id', sa.Integer(), nullable=False),
    sa.Column('order_id', sa.Integer(), nullable=False),
    sa.Column('used_at', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.ForeignKeyConstraint(['discount_id'], ['discount_codes.id'], ),
    sa.ForeignKeyConstraint(['order_id'], ['orders.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.user_id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###

def downgrade() -> None:
    """Downgrade schema."""
    # ایندکس‌ها
    op.drop_index('ix_orders_user_id_expiration_date', table_name='orders')
    op.drop_index('ix_orders_order_code', table_name='orders')
    op.drop_index('ix_orders_user_id', table_name='orders')
    op.drop_index('ix_link_pool_plan_id', table_name='link_pool')

    # جدول‌ها (برعکس ترتیب ساخت)
    op.drop_table('discount_usages')
    op.drop_table('orders')
    op.drop_table('link_pool')
    op.drop_table('plans')
    op.drop_table('users')
    op.drop_table('user_phones')
    op.drop_table('unlimited_rotation_groups')
    op.drop_table('settings')
    op.drop_table('plan_categories')
    op.drop_table('notification_logs')
    op.drop_table('discount_codes')
    op.drop_table('cron_status')
