# bot/keyboards/user.py

from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton
from database.queries import get_all_categories, get_plans_by_category

# ---------- دسته‌بندی‌ها ----------
from database.queries import get_plans_by_category, get_all_categories

async def build_plans_keyboard() -> InlineKeyboardMarkup:
    cats = await get_all_categories()
    buttons = []
    for c in cats:
        text = f"{c.title} ({c.type})"
        if c.is_full:
            # دکمه‌ای که صرفا آلرت بده
            buttons.append([
                InlineKeyboardButton(
                    text=f"{text}  (تکمیل ظرفیت)",
                    callback_data=f"filled_category_{c.id}"
                )
            ])
        else:
            buttons.append([
                InlineKeyboardButton(
                    text=text,
                    callback_data=f"category_{c.id}"
                )
            ])
    return InlineKeyboardMarkup(inline_keyboard=buttons)

# ---------- پلن‌های یک دسته ----------
async def build_plans_list_keyboard(category_id: int) -> InlineKeyboardMarkup:
    plans = await get_plans_by_category(category_id)
    buttons = []
    for p in plans:
        text = f"{p.name} – {int(p.price)} تومان"
        if p.is_full:
            buttons.append([
                InlineKeyboardButton(
                    text=f"{text}  (تکمیل ظرفیت)",
                    callback_data=f"filled_plan_{p.id}"
                )
            ])
        else:
            buttons.append([
                InlineKeyboardButton(
                    text=text,
                    callback_data=f"plan_{p.id}"
                )
            ])
    buttons.append([InlineKeyboardButton(text="🔙 بازگشت", callback_data="back_to_categories")])
    return InlineKeyboardMarkup(inline_keyboard=buttons)


# ------------------------------------------------------------------
# بعد از نمایش اولیهٔ فاکتور: فقط دکمهٔ «روش پرداخت»
# ------------------------------------------------------------------
def build_payment_method_keyboard(order_id: int) -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(inline_keyboard=[
        [
            InlineKeyboardButton(
                text="💳 پرداخت",
                callback_data=f"show_payment_info_{order_id}"
            ),
            InlineKeyboardButton(
                text="🎟️ دریافت تخفیف",
                callback_data=f"get_gift_{order_id}"
            )
        ]
    ])


# ------------------------------------------------------------------
# بعد از کلیک روی «روش پرداخت»: دکمه‌های ارسال رسید و لغو خرید
# ------------------------------------------------------------------
def build_receipt_keyboard(order_id: int) -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(inline_keyboard=[
        [
            InlineKeyboardButton(
                text="📤 ارسال رسید پرداخت",
                callback_data=f"upload_receipt_{order_id}"
            ),
            InlineKeyboardButton(
                text="❌ لغو خرید",
                callback_data="cancel_purchase"
            )
        ]
    ])



def get_user_panel_keyboard() -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(
        inline_keyboard=[
            [
                InlineKeyboardButton(
                    text="🔖 اشتراک من",
                    callback_data="user:my_subscription"
                )
            ],
            [
                InlineKeyboardButton(
                    text="🛒 خرید پلن",
                    callback_data="user:buy_plan"
                )
            ],
            [
                InlineKeyboardButton(
                    text="❓ راهنما",
                    callback_data="user:help"
                )
            ]
        ]
    )
