# bot/menu/main_menu.py
from aiogram.types import ReplyKeyboardMarkup, KeyboardButton

# دیکشنری منو: متن دکمه ← کلید هندلر
MENU_COMMANDS = {
    "🏠 خانه": "start_handler",
    "🛒 خرید VPN": "buy",
    "♻️ تمدید سرویس": "renew",   # ← تمدید سرویس
    "💡 راهنمای اتصال": "help",
    "☎️ پشتیبانی": "support",
    "🌐 اشتراک‌های فعال من": "my_subscription",
    "🎁 اعتبار هدیه‌ی من": "gift",
    "🆓 دریافت تست رایگان": "free_test_command",
    "✅ اعتماد و رضایت شما": "trust_and_feedback",
    "❌ درخواست بازگشت وجه": "refund_request",
}
# برای ویرایش داخل فایل handlers/user.py عبارت 'fallback_name_map' را سرچ کنید و اسم تابع و نه command  را قرار دهید. 

def get_main_menu():
    """
    ساخت منوی اصلی بر اساس دیکشنری MENU_COMMANDS (دو ستونه)
    """
    labels = list(MENU_COMMANDS.keys())
    keyboard = []

    # هر دو دکمه در یک ردیف
    for i in range(0, len(labels), 2):
        row = [KeyboardButton(text=labels[i])]
        if i + 1 < len(labels):  # اگر دکمه دوم هم وجود داشت
            row.append(KeyboardButton(text=labels[i + 1]))
        keyboard.append(row)

    return ReplyKeyboardMarkup(
        keyboard=keyboard,
        resize_keyboard=True,
        input_field_placeholder="یکی از گزینه‌ها را انتخاب کنید..."
    )
