# bot/middlewares/membership.py
from aiogram import BaseMiddleware, Bot, types
from aiogram.types import Message, CallbackQuery
from aiogram.utils.keyboard import InlineKeyboardBuilder
from bot.utils.user_check import is_user_verified  # async function

CHANNEL_USERNAME = "@mushak_vpn"

async def is_user_member(user_id: int, bot: Bot) -> bool:
    try:
        member = await bot.get_chat_member(chat_id=CHANNEL_USERNAME, user_id=user_id)
        return member.status in ["member", "administrator", "creator"]
    except:
        return False

class MembershipMiddleware(BaseMiddleware):
    """
    Middleware ترکیبی:
    1️⃣ بررسی تایید شماره تماس کاربر
    2️⃣ بررسی عضویت کاربر در کانال
    """

    
    async def __call__(self, handler, event, data: dict):
        bot: Bot = data["bot"]
        user_id = event.from_user.id
        

        # ✅ عبور کامل برای /start و contact
        if isinstance(event, Message):
            if event.text and event.text.startswith("/start"):
                return await handler(event, data)

            if event.contact:
                return await handler(event, data)


        # --- 1) بررسی شماره تماس ---
        if not await is_user_verified(user_id):
            keyboard = types.ReplyKeyboardMarkup(
                keyboard=[
                    [types.KeyboardButton(text="📞 ارسال شماره تماس", request_contact=True)]
                ],
                resize_keyboard=True,
                one_time_keyboard=True
            )
            await event.answer(
                "⚠️ لطفاً ابتدا شماره تماس خود را تایید کنید 👇",
                reply_markup=keyboard
            )
            return
        

        # --- 2) بررسی عضویت در کانال ---
        if not await is_user_member(user_id, bot):
            builder = InlineKeyboardBuilder()
            builder.button(
                text="📢 عضویت در کانال",
                url=f"https://t.me/{CHANNEL_USERNAME.lstrip('@')}"
            )
            builder.button(
                text="🔁 بررسی عضویت",
                callback_data="check_membership"
            )
            builder.adjust(1)
            markup = builder.as_markup()

            if isinstance(event, Message):
                await event.answer(
                    "🔒 برای استفاده از ربات ابتدا عضو کانال شوید:",
                    reply_markup=markup
                )
            elif isinstance(event, CallbackQuery):
                await event.message.answer(
                    "🔒 برای استفاده از ربات ابتدا عضو کانال شوید:",
                    reply_markup=markup
                )
            return

        # ✅ همه شرایط برقرار → اجرای هندلر اصلی
        return await handler(event, data)


