# bot/utils/error_reporter.py
import traceback
from datetime import datetime
from aiogram import Bot

LOG_FILE = "webhook_errors.log"

async def report_error(bot: Bot, admin_id: int, context: str, error: Exception):
    """
    ارسال گزارش خطا به ادمین و ذخیره در فایل.
    """
    error_text = "".join(traceback.format_exception(type(error), error, error.__traceback__))
    timestamp = datetime.now().strftime("%Y-%m-%d %H:%M:%S")

    log_entry = f"[{timestamp}] ❌ {context}\n{error_text}\n{'-'*60}\n"

    # ذخیره در فایل
    with open(LOG_FILE, "a", encoding="utf-8") as f:
        f.write(log_entry)

    # ارسال به ادمین (در تلگرام)
    text = (
        f"⚠️ <b>گزارش خطای وبهوک</b>\n\n"
        f"🕓 <b>زمان:</b> {timestamp}\n"
        f"📍 <b>محل وقوع:</b> {context}\n"
        f"💬 <b>پیام خطا:</b>\n<pre>{str(error)}</pre>"
    )

    try:
        await bot.send_message(admin_id, text, parse_mode="HTML")
    except Exception:
        pass  # اگر ارسال به ادمین هم شکست خورد، فقط در فایل ذخیره می‌شود
