# bot/utils/helpers.py

from datetime import datetime
import jdatetime


def format_shamsi_date(dt: datetime) -> str:
    """
    ورودی: یک شیء datetime از گِرگوریان
    خروجی: رشته‌ای به صورت 'YYYY/MM/DD' شمسی
    """
    shamsi = jdatetime.datetime.fromgregorian(datetime=dt)
    return shamsi.strftime("%Y/%m/%d")


def shamsi_to_gregorian(shamsi_str: str) -> datetime:
    """
    ورودی: تاریخ شمسی به صورت رشته 'YYYY/MM/DD'
    خروجی: شیء datetime میلادی
    """
    year, month, day = map(int, shamsi_str.split("/"))
    return jdatetime.date(year, month, day).togregorian()


def calculate_discount_based_on_date(order_date: datetime) -> int:
    """
    این تابع تخفیف را بر اساس تاریخ خرید اعمال می‌کند. اگر تاریخ خرید در روزهای خاص باشد (0، 5، 10 و ...)،
    تخفیف اعمال نمی‌شود. در غیر این صورت تخفیف 10 درصدی اعمال می‌شود.
    """
    # تاریخ شروع (باید با توجه به پروژه تنظیم شود)
    start_date = datetime(2025, 1, 1)  # این تاریخ می‌تواند به دلخواه شما تغییر یابد

    # محاسبه تفاوت روزها
    delta_days = (order_date - start_date).days

    # روزهای خاص که تخفیف اعمال نمی‌شود (0، 5، 10، 15، 20، 25)
    exempt_days = [0, 5, 10, 15, 20, 25]

    if delta_days % 5 == 0:  # تاریخ خرید دقیقا در یکی از روزهای خاص است
        return 0  # بدون تخفیف

    return 10  # تخفیف 10 درصد
