# tests/conftest.py
import sys
import os

# اینجا سطح پوشه tests رو یک‌بار بالا می‌رویم تا به ریشهٔ پروژه برسیم
project_root = os.path.abspath(os.path.join(os.path.dirname(__file__), ".."))
sys.path.insert(0, project_root)

# حالا واردات‌های پروژه درست کار می‌کنند:
import pytest
from sqlalchemy.ext.asyncio import create_async_engine, AsyncSession
from sqlalchemy.orm import sessionmaker

from database.base import Base        # یا مسیر صحیح Base در پروژهٔ شما

DATABASE_URL = "sqlite+aiosqlite:///:memory:"

@pytest.fixture(scope="session")
def engine():
    return create_async_engine(DATABASE_URL, echo=False)

@pytest.fixture(scope="session")
async def initialized_db(engine):
    # ساخت جداول
    async with engine.begin() as conn:
        await conn.run_sync(Base.metadata.create_all)
    yield
    # در صورت نیاز در teardown چیزی نیازی نیست

@pytest.fixture
async def session(engine, initialized_db):
    async_session = sessionmaker(engine, class_=AsyncSession, expire_on_commit=False)
    async with async_session() as session:
        yield session
